<?php

/**
 * Plugin Name: Microloader
 * Plugin URI: https://themeover.com/
 * Description: Load Themeover assets in production with minimal overhead.
 * Author: Sebastian Webb
 * Version: 1.2
 */

// Stop direct call
if ( !defined( 'ABSPATH') ) exit;

function init_microloader() {

	if ( defined( 'MT_IS_ACTIVE' ) ) return;

	$dir      = WP_CONTENT_DIR . '/micro-themes/';
	$autoload = $dir . 'autoload.php';
	$file     = $dir . 'AssetLoad.php';

	if ( ! class_exists( '\Microthemer\AssetLoad' ) && file_exists( $autoload ) && file_exists( $file ) ) {
		require $autoload;
		new \Microthemer\AssetLoad( true );
	}
}

add_action( 'plugins_loaded', 'init_microloader' );